
{----------------------------------------------------------------------

  file PBeep.p

  This sample XCMD has the following syntax:

	PBeep		beep once
	PBeep ##	beep n times
	PBeep ?		display usage information
	PBeep !		display version information

  Copyright Apple Computer, Inc.  1989-1991
  All Rights Reserved.
   
----------------------------------------------------------------------}

UNIT DummyUnit;

{$Z+}		{ Not strictly needed, however these flags make the output	}
{$N+}		{ easier to read when a XCMD is disassembled with DumpObjIIGS	}

INTERFACE

USES Types,
     MiscTool,
     QuickDraw,
     GSOS,
     HyperXCMD;
     

PROCEDURE EntryPoint(paramPtr: XCmdPtr);



IMPLEMENTATION


{  Define any "global" variables here	}

VAR gParamPtr:	XCmdPtr;


{  Declare all subroutines here as FORWARD	}

PROCEDURE PBeep(paramPtr: XCmdPtr);	FORWARD;


{  First code is the entry point.  We actually put it in a separate object segment,
   so the linker can extract it an make it the very first byte of code	}

{$S EntrySeg	}
{----------------------------------------------------------------------}
PROCEDURE EntryPoint(paramPtr: XCmdPtr);

{  This is the entry point to the program.

   For a really simple XCMD you could just put the code all in here,
   for cleanliness' sake this example calls another routine down in the
   main area of the XCMD.

   NOTE:  Make sure that when you link the XCMD or XFCN, that this entry
	  point is THE FIRST byte of the resource.  HyperTalk will jump
	  to the very first byte of the module, so it should contain code!

   INPUTS:	paramPtr	Points to the XCMD parameter block.
   OUTPUTS:	
   ERRORS:
   SIDE EFFECTS:
}
BEGIN
  PBeep(paramPtr);
END;


{  Finally, the definitions for all the other procedures and functions.	}


{$S Main	}
{----------------------------------------------------------------------}
PROCEDURE PBeep(paramPtr: XCmdPtr);

{  Main code for the Beep XCMD.  Interpret the incoming parameters and
   beep the speaker!

   INPUTS:	paramPtr	Points to XCMD parameter block.
   OUTPUTS:	
   ERRORS:
   SIDE EFFECTS:
}
VAR beepCount:	INTEGER;
    counter:	INTEGER;
    str:		Str255;
BEGIN
  gParamPtr := paramPtr;	{ handy to copy it into a global, for other procs	}
  
  IF paramPtr^.paramCount > 0 THEN BEGIN
    ZeroToPas(paramPtr^.params[1]^, str);	{ get param #1 into local string	}

	IF StringEqual(str, '?') THEN BEGIN		{ check for special characters	}
	  SendCardMessage('answer "FORM: PBeep {count}"');
	  EXIT(PBeep);
	END
	ELSE IF StringEqual(str, '!') THEN BEGIN
	  SendCardMessage('answer "PBeep XCMD v1.0" & return & " 1991 Apple Computer, Inc."');
	  EXIT(PBeep);
	END;
	
    beepCount := StrToNum(str);				{ not special char.  use as counter	}
  END
  ELSE beepCount := 1;						{ no parameter typed.  just beep once.	}
  
  IF beepCount > 15 THEN beepCount := 15;	{ limit ourselves to 15 beeps	}
  
  FOR counter := 1 TO beepCount DO SysBeep;
END;


END.	{ of the dummy unit	}
